# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    # Check if opponent is always defecting
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Late-game defection (last 2 rounds)
    if len(opp_history) >= 8:  # Rounds 9-10 (0-based index 8 and 9)
        if all(move == "C" for move in opp_history):
            return "D"
    
    # Check for two consecutive defections
    if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        return "D"
    
    # Tit-for-Tat logic
    if opp_history[-1] == "D":
        return "D"
    else:
        return "C"